/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops;

import com.ibm.hwmca.fw.schedops.ScheduleException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class Schedule
implements Serializable {
    private static final String CLASS_NAME = "[Schedule] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    public static final long SCHEDULE_INDEFINITELY = -1L;
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long TEN_MINUTES = 600000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    private Date originalDate;
    private long originalRepetitions;
    private long windowOfOpportunity;
    private long schedulingFrequency;

    public Schedule(Date date, long woo) {
        this(date, woo, 1L, 0L);
    }

    public Schedule(Date date, long woo, long reps, long freq) {
        Trace.trace(TRACE_MASKT, "[Schedule] >> Schedule()");
        ScheduleException.Error error = null;
        if (date == null) {
            error = ScheduleException.Error.DATE;
        } else if (woo <= 0L) {
            error = ScheduleException.Error.WINDOW;
        } else if (reps <= 0L && reps != -1L) {
            error = ScheduleException.Error.REPETITIONS;
        } else if ((reps > 1L || reps == -1L) && freq <= 0L) {
            error = ScheduleException.Error.FREQUENCY;
        } else if ((reps > 1L || reps == -1L) && woo >= freq) {
            error = ScheduleException.Error.WIND_FREQ;
        }
        if (error == null) {
            this.originalDate = new Date(date.getTime());
            this.windowOfOpportunity = woo;
            this.originalRepetitions = reps;
            this.schedulingFrequency = freq;
            if (this.getNextScheduledDate() == null) {
                error = ScheduleException.Error.EXPIRED;
            }
        }
        if (error != null) {
            throw new ScheduleException(error, "Illegal argument(s)");
        }
        Trace.trace(TRACE_MASKT, "[Schedule] << Schedule() : " + this.toString());
    }

    public Date getOriginalDate() {
        return new Date(this.originalDate.getTime());
    }

    public long getOriginalRepetitions() {
        return this.originalRepetitions;
    }

    public long getWindowOfOpportunity() {
        return this.windowOfOpportunity;
    }

    public long getSchedulingFrequency() {
        return this.schedulingFrequency;
    }

    public long getRemainingRepetitions() {
        return this.getRemainingRepetitions(new Date(System.currentTimeMillis()));
    }

    public long getRemainingRepetitions(Date date) {
        long result = this.originalRepetitions;
        if (result > 0L) {
            long currLong = this.originalDate.getTime();
            long dateLong = date.getTime();
            while (currLong + this.windowOfOpportunity <= dateLong && result-- > 0L) {
                currLong += this.schedulingFrequency;
            }
        }
        return result;
    }

    public boolean isExpired() {
        return this.isExpired(new Date());
    }

    public boolean isExpired(Date date) {
        return this.getRemainingRepetitions(date) == 0L;
    }

    public boolean isScheduledIndefinitely() {
        return this.originalRepetitions <= -1L;
    }

    public Date getNextScheduledDate() {
        return this.getNextScheduledDate(new Date(System.currentTimeMillis()));
    }

    public Date getNextScheduledDate(Date afterDate) {
        Date result = null;
        long afterLong = afterDate.getTime();
        long currLong = this.originalDate.getTime();
        long remainReps = this.originalRepetitions;
        while (currLong + this.windowOfOpportunity <= afterLong && (this.originalRepetitions <= -1L || remainReps-- > 0L)) {
            currLong += this.schedulingFrequency;
        }
        if (this.originalRepetitions <= -1L || remainReps > 0L) {
            result = new Date(currLong);
        }
        return result;
    }

    public List getScheduledDates(Date fromDate, Date toDate) {
        long toLong;
        ArrayList<Date> result = new ArrayList<Date>();
        long fromLong = fromDate.getTime();
        if (fromLong <= (toLong = toDate.getTime())) {
            long origLong;
            long reps = this.originalRepetitions;
            for (long currLong = origLong = this.originalDate.getTime(); currLong >= fromLong && currLong + this.windowOfOpportunity <= toLong && (this.originalRepetitions <= -1L || reps-- > 0L); currLong += this.schedulingFrequency) {
                result.add(new Date(currLong));
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Schedule=[");
        buffer.append("Date=");
        buffer.append(this.getNextScheduledDate());
        buffer.append("; Wind=");
        buffer.append(this.windowOfOpportunity);
        buffer.append("; Reps=");
        buffer.append(this.getRemainingRepetitions());
        buffer.append("; Freq=");
        buffer.append(this.schedulingFrequency);
        buffer.append("]");
        return buffer.toString();
    }
}

